package scripts.instead_of_edit_task;

import com.trackstudio.app.adapter.AdapterManager;
import com.trackstudio.app.csv.CSVImport;
import com.trackstudio.exception.GranException;
import com.trackstudio.external.TaskTrigger;
import com.trackstudio.secured.*;
import com.trackstudio.startup.I18n;

import java.util.Calendar;

/**
 *     
 */
public class LogChanges implements TaskTrigger {
    public SecuredTaskTriggerBean execute(SecuredTaskTriggerBean task) throws GranException {
        StringBuffer sb2 = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        sb2.append("<table class=\"general\" cellpadding=4>");
        String budget = task.getBudgetAsString();

        Calendar deadline = task.getDeadline();
        SecuredPrstatusBean group = task.getHandlerGroup();
        SecuredUserBean user = task.getHandlerUser();
        SecuredPriorityBean priority = task.getPriority();
        SecuredResolutionBean resolution = task.getResolution();
        String description = task.getDescription();
        String name = task.getName();
        String alias = task.getShortname();

        SecuredTaskBean oldTask = new SecuredTaskBean(task.getId(), task.getSecure());
        String _name = oldTask.getName();
        String _alias = oldTask.getShortname();
        String _budget = oldTask.getBudgetAsString();
        Calendar _deadline = oldTask.getDeadline();
        SecuredPrstatusBean _group = oldTask.getHandlerGroup();
        SecuredUserBean _user = oldTask.getHandlerUser();
        SecuredPriorityBean _priority = oldTask.getPriority();
        SecuredResolutionBean _resolution = oldTask.getResolution();
        String _description = oldTask.getDescription();
        if ((_name != null && !_name.equals(name)) || (_name == null && name != null)) {
            sb.append("<tr>");
            sb.append("<th align=\"right\">");
            sb.append(I18n.getString(task.getSecure(), "NAME"));
            sb.append("</th>");
            sb.append("<td><strike>");
            sb.append(_name);
            sb.append("</strike></td>");
            sb.append("<td>");
            sb.append(name);
            sb.append("</td>");
            sb.append("</tr>\n");

        }

        if ((_alias != null && !_alias.equals(alias)) || (_alias == null && alias != null)) {
            sb.append("<tr>");
            sb.append("<th align=\"right\">");
            sb.append(I18n.getString(task.getSecure(), "ALIAS"));
            sb.append("</th>");
            sb.append("<td><strike>");
            sb.append(_alias);
            sb.append("</strike></td>");
            sb.append("<td>");
            sb.append(alias);
            sb.append("</td>");
            sb.append("</tr>\n");

        }

        if ((_budget != null && !_budget.equals(budget)) || (_budget == null && budget != null)) {
            sb.append("<tr>");
            sb.append("<th align=\"right\">");
            sb.append(I18n.getString(task.getSecure(), "BUDGET"));
            sb.append("</th>");
            sb.append("<td><strike>");
            sb.append(_budget);
            sb.append("</strike></td>");
            sb.append("<td>");
            sb.append(budget);
            sb.append("</td>");
            sb.append("</tr>\n");

        }
        if ((_deadline != null && !_deadline.equals(deadline)) || (_deadline == null && deadline != null)) {
            sb.append("<tr>");
            sb.append("<th align=\"right\">");
            sb.append(I18n.getString(task.getSecure(), "DEADLINE"));
            sb.append("</th>");
            sb.append("<td><strike>");
            if (_deadline != null)
                sb.append(task.getSecure().getUser().getDateFormatter().parse(_deadline));
            sb.append("</strike></td>");
            sb.append("<td>");
            if (deadline != null)
                sb.append(task.getSecure().getUser().getDateFormatter().parse(deadline));
            sb.append("</td>");
            sb.append("</tr>\n");

        }
        if ((_priority != null && !_priority.equals(priority)) || (_priority == null && priority != null)) {
            sb.append("<tr>");
            sb.append("<th align=\"right\">");
            sb.append(I18n.getString(task.getSecure(), "PRIORITY"));
            sb.append("</th>");
            sb.append("<td><strike>");
            if (_priority != null)
                sb.append(_priority.getName());
            sb.append("</strike></td>");
            sb.append("<td>");
            if (priority != null)
                sb.append(priority.getName());
            sb.append("</td>");
            sb.append("</tr>\n");

        }
        if ((_resolution != null && !_resolution.equals(resolution)) || (_resolution == null && resolution != null)) {
            sb.append("<tr>");
            sb.append("<th align=\"right\">");
            sb.append(I18n.getString(task.getSecure(), "RESOLUTION"));
            sb.append("</th>");
            sb.append("<td><strike>");
            if (_resolution != null)
                sb.append(_resolution.getName());
            sb.append("</strike></td>");
            sb.append("<td>");
            if (resolution != null)
                sb.append(resolution.getName());
            sb.append("</td>");
            sb.append("</tr>\n");

        }
        if ((_user != null && !_user.equals(user)) || (_user == null && user != null)) {
            sb.append("<tr>");
            sb.append("<th align=\"right\">");
            sb.append(I18n.getString(task.getSecure(), "HANDLER"));
            sb.append("</th>");
            sb.append("<td><strike>");
            if (_user != null)
                sb.append(_user.getName());
            sb.append("</strike></td>");
            sb.append("<td>");
            if (user != null)
                sb.append(user.getName());
            sb.append("</td>");
            sb.append("</tr>\n");

        }
        if ((_group != null && !_group.equals(group)) || (_group == null && group != null)) {
            sb.append("<tr>");
            sb.append("<th align=\"right\">");
            sb.append(I18n.getString(task.getSecure(), "HANDLER"));
            sb.append("</th>");
            sb.append("<td><strike>");
            if (_group != null)
                sb.append(_group.getName());
            sb.append("</strike></td>");
            sb.append("<td>");
            if (group != null)
                sb.append(group.getName());
            sb.append("</td>");
            sb.append("</tr>\n");

        }
        if ((_description != null && !_description.equals(description)) || (_description == null && description != null)) {
            sb.append("<tr>");
            sb.append("<th align=\"right\">");
            sb.append(I18n.getString(task.getSecure(), "DESCRIPTION"));
            sb.append("</th>");
            sb.append("<td><strike>");
            sb.append(_description);
            sb.append("</strike></td>");
            sb.append("<td>");
            sb.append(description);
            sb.append("</td>");
            sb.append("</tr>\n");

        }
        if (task.getUdfValues() != null && !task.getUdfValues().isEmpty()) {

            for (Object okey : task.getUdfValues().keySet()) {
                String key = okey.toString();
                String value = task.getUdfValues().get(key).toString();
                String oldValue = AdapterManager.getInstance().getSecuredUDFAdapterManager()
                        .getTaskUDFValue(task.getSecure(), task.getId(), key);
                if ((oldValue != null && !oldValue.equals(value))
                        || (oldValue == null && value != null)) {
                    sb.append("<tr>");
                    sb.append("<th align=\"right\">");
                    sb.append(key);
                    sb.append("</th>");
                    sb.append("<td><strike>");
                    sb.append(oldValue);
                    sb.append("</strike></td>");
                    sb.append("<td>");
                    sb.append(value);
                    sb.append("</td>");
                    sb.append("</tr>\n");

                }
            }
        }
        SecuredMessageTriggerBean createMessage = null;
        if (sb.length() > 0) {
            sb2.append(sb);
            sb2.append("</table>\n");
            String mstatusId = CSVImport.findMessageTypeIdByName("Log", task.getCategory().getName());
            /**
             *  SecuredMessageTriggerBean
             */
            createMessage = new SecuredMessageTriggerBean(
                    null /*  */,
                    sb2.toString() /*   */,
                    Calendar.getInstance() /*    */,
                    null /*   */,
                    task.getDeadline() /*    (deadline) */,
                    task.getBudget() /*  */,
                    task.getId() /*  */,
                    task.getSecure().getUserId() /*   */,
                    null /*  */,
                    task.getPriorityId() /*  */,
                    task.getHandlerId() /*  */,
                    task.getHandlerUserId() /*  */,
                    task.getHandlerGroupId() /* ,        */,
                    mstatusId /*   */,
                    null /* Map    */,
                    task.getSecure() /* SessionContext */,
                    null /*  */);
            /**
             * 
             */

        }
        task.update(true);
        if (createMessage != null) createMessage.create(false);
        return task;
    }


}
