package scripts.instead_of_add_message;

import com.trackstudio.app.adapter.AdapterManager;
import com.trackstudio.app.csv.CSVImport;
import com.trackstudio.exception.GranException;
import com.trackstudio.external.OperationTrigger;
import com.trackstudio.secured.*;
import com.trackstudio.startup.I18n;


import java.util.Calendar;

public class LogChanges implements OperationTrigger {
    public SecuredMessageTriggerBean execute(SecuredMessageTriggerBean message) throws GranException {
        StringBuffer sb2 = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        sb2.append("<table class=\"general\" cellpadding=4>");
        String budget = message.getBudgetAsString();
        Calendar deadline = message.getDeadline();
        SecuredPrstatusBean group = message.getHandlerGroup();
        SecuredUserBean user = message.getHandlerUser();
        SecuredPriorityBean priority = message.getPriority();
        SecuredResolutionBean resolution = message.getResolution();
        SecuredStatusBean state = message.getTask().getStatus();

        String _budget = message.getTask().getBudgetAsString();
        Calendar _deadline = message.getTask().getDeadline();
        SecuredPrstatusBean _group = message.getTask().getHandlerGroup();
        SecuredUserBean _user = message.getTask().getHandlerUser();
        SecuredPriorityBean _priority = message.getTask().getPriority();
        SecuredResolutionBean _resolution = message.getTask().getResolution();
        SecuredStatusBean _state = null;
        for (SecuredTransitionBean t : message.getMstatus().getTransitions()) {
            if (t.getStart().equals(state)) _state = t.getFinish();
            break;
        }

        if ((_budget != null && !_budget.equals(budget)) || (_budget == null && budget != null)) {
            sb.append("<tr>");
            sb.append("<th align=\"right\">");
            sb.append(I18n.getString(message.getSecure(), "BUDGET"));
            sb.append("</th>");
            sb.append("<td><strike>");
            sb.append(_budget);
            sb.append("</strike></td>");
            sb.append("<td>");
            sb.append(budget);
            sb.append("</td>");
            sb.append("</tr>\n");

        }
        if ((_deadline != null && !_deadline.equals(deadline)) || (_deadline == null && deadline != null)) {
            sb.append("<tr>");
            sb.append("<th align=\"right\">");
            sb.append(I18n.getString(message.getSecure(), "DEADLINE"));
            sb.append("</th>");
            sb.append("<td><strike>");
            if (_deadline != null)
                sb.append(message.getSecure().getUser().getDateFormatter().parse(_deadline));
            sb.append("</strike></td>");
            sb.append("<td>");
            if (deadline != null)
                sb.append(message.getSecure().getUser().getDateFormatter().parse(deadline));
            sb.append("</td>");
            sb.append("</tr>\n");

        }
        if ((_priority != null && !_priority.equals(priority)) || (_priority == null && priority != null)) {
            sb.append("<tr>");
            sb.append("<th align=\"right\">");
            sb.append(I18n.getString(message.getSecure(), "PRIORITY"));
            sb.append("</th>");
            sb.append("<td><strike>");
            if (_priority != null)
                sb.append(_priority.getName());
            sb.append("</strike></td>");
            sb.append("<td>");
            if (priority != null)
                sb.append(priority.getName());
            sb.append("</td>");
            sb.append("</tr>\n");

        }
        if ((_resolution != null && !_resolution.equals(resolution)) || (_resolution == null && resolution != null)) {
            sb.append("<tr>");
            sb.append("<th align=\"right\">");
            sb.append(I18n.getString(message.getSecure(), "RESOLUTION"));
            sb.append("</th>");
            sb.append("<td><strike>");
            if (_resolution != null)
                sb.append(_resolution.getName());
            sb.append("</strike></td>");
            sb.append("<td>");
            if (resolution != null)
                sb.append(resolution.getName());
            sb.append("</td>");
            sb.append("</tr>\n");

        }
        if ((_user != null && !_user.equals(user)) || (_user == null && user != null)) {
            sb.append("<tr>");
            sb.append("<th align=\"right\">");
            sb.append(I18n.getString(message.getSecure(), "HANDLER"));
            sb.append("</th>");
            sb.append("<td><strike>");
            if (_user != null)
                sb.append(_user.getName());
            sb.append("</strike></td>");
            sb.append("<td>");
            if (user != null)
                sb.append(user.getName());
            sb.append("</td>");
            sb.append("</tr>\n");

        }
        if ((_group != null && !_group.equals(group)) || (_group == null && group != null)) {
            sb.append("<tr>");
            sb.append("<th align=\"right\">");
            sb.append(I18n.getString(message.getSecure(), "HANDLER"));
            sb.append("</th>");
            sb.append("<td><strike>");
            if (_group != null)
                sb.append(_group.getName());
            sb.append("</strike></td>");
            sb.append("<td>");
            if (group != null)
                sb.append(group.getName());
            sb.append("</td>");
            sb.append("</tr>\n");

        }
        if ((_state != null && !_state.equals(state)) || (_state == null && state != null)) {
            sb.append("<tr>");
            sb.append("<th align=\"right\">");
            sb.append(I18n.getString(message.getSecure(), "TASK_STATE"));
            sb.append("</th>");
            sb.append("<td><strike>");
            sb.append(_state.getName());
            sb.append("</strike></td>");
            sb.append("<td>");
            sb.append(state.getName());
            sb.append("</td>");
            sb.append("</tr>\n");

        }
        if (message.getUdfValues() != null && !message.getUdfValues().isEmpty()) {

            for (Object okey : message.getUdfValues().keySet()) {
                String key = okey.toString();
                String value = message.getUdfValues().get(key).toString();
                String oldValue = AdapterManager.getInstance().getSecuredUDFAdapterManager()
                        .getTaskUDFValue(message.getSecure(), message.getTaskId(), key);
                if ((oldValue != null && !oldValue.equals(value))
                        || (oldValue == null && value != null)) {
                    sb.append("<tr>");
                    sb.append("<th align=\"right\">");
                    sb.append(key);
                    sb.append("</th>");
                    sb.append("<td><strike>");
                    sb.append(oldValue);
                    sb.append("</strike></td>");
                    sb.append("<td>");
                    sb.append(value);
                    sb.append("</td>");
                    sb.append("</tr>\n");

                }
            }
        }
        SecuredMessageTriggerBean createMessage = null;
        if (sb.length() > 0) {
            sb2.append(sb);
            sb2.append("</table>\n");
            String mstatusId = CSVImport.findMessageTypeIdByName("Log", message.getTask().getCategory().getName());
            /**
             *  SecuredMessageTriggerBean
             */
            createMessage = new SecuredMessageTriggerBean(
                    null /*  */,
                    sb2.toString() /*   */,
                    Calendar.getInstance() /*    */,
                    null /*   */,
                    message.getDeadline() /*    (deadline) */,
                    message.getBudget() /*  */,
                    message.getTaskId() /*  */,
                    message.getSecure().getUserId() /*   */,
                    null /*  */,
                    message.getPriorityId() /*  */,
                    message.getHandlerId() /*  */,
                    message.getHandlerUserId() /*  */,
                    message.getHandlerGroupId() /* ,        */,
                    mstatusId /*   */,
                    null /* Map    */,
                    message.getSecure() /* SessionContext */,
                    null /*  */);
            /**
             * 
             */

        }
        message.create(true);
        if (createMessage != null) createMessage.create(false);
        return message;
    }
}
